<?php

$performance = \WpCafe\Core\Modules\Food_Menu\Hooks::instance()->monthly_report();

$currency_symbol = class_exists('Woocommerce') ? get_woocommerce_currency_symbol()  :"$";
$wpc_banner_image_url = \Wpcafe::assets_url() . 'images/overview_image.jpg';
?>

<!-- header start -->
<?php include_once \Wpcafe::core_dir() . "settings/layout/header.php"; ?>
<!-- header end -->

<div class="wpc-admin-sec wpc-banner-section">
    <div class="wpc-banner-image">
        <img src="<?php echo esc_url($wpc_banner_image_url); ?>" alt="" />
    </div>
</div>

<div class="wpc-admin-sec wpc-admin-performance">
    <h2 class="wpc-heading"><?php echo esc_html__('Performance', 'wpcafe' ) ?></h2>
    <div class="wpc-row wpc-admin-performance-wrap">
        <div class="wpc-col-lg-3 wpc-col-md-6">
            <div class="wpc-performance-item">
                <div class="wpc-overview-icon">
                    <svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle opacity="0.15" cx="35" cy="35" r="35" fill="#24A4EC"/>
                        <path d="M41.5614 24.1171V22.0121C41.5614 21.4588 41.1024 21 40.5489 21C39.9954 21 39.5365 21.4588 39.5365 22.0121V24.0362H30.7619V22.0121C30.7619 21.4588 30.3029 21 29.7495 21C29.196 21 28.737 21.4588 28.737 22.0121V24.1171C25.0922 24.4545 23.3238 26.627 23.0538 29.8521C23.0268 30.2435 23.3508 30.5673 23.7288 30.5673H46.5696C46.9611 30.5673 47.2851 30.23 47.2446 29.8521C46.9746 26.627 45.2062 24.4545 41.5614 24.1171Z" fill="#24A4EC"/>
                        <path d="M45.9489 32.5913H24.3499C23.6075 32.5913 23 33.1985 23 33.9407V42.2531C23 46.3014 25.0249 49.0002 29.7497 49.0002H40.5491C45.2739 49.0002 47.2988 46.3014 47.2988 42.2531V33.9407C47.2988 33.1985 46.6913 32.5913 45.9489 32.5913ZM31.3831 43.8859C31.2481 44.0073 31.0996 44.1018 30.9376 44.1693C30.7756 44.2368 30.6001 44.2772 30.4246 44.2772C30.2491 44.2772 30.0737 44.2368 29.9117 44.1693C29.7497 44.1018 29.6012 44.0073 29.4662 43.8859C29.2232 43.6295 29.0747 43.2787 29.0747 42.9278C29.0747 42.577 29.2232 42.2261 29.4662 41.9697C29.6012 41.8483 29.7497 41.7538 29.9117 41.6864C30.2356 41.5514 30.6136 41.5514 30.9376 41.6864C31.0996 41.7538 31.2481 41.8483 31.3831 41.9697C31.6261 42.2261 31.7746 42.577 31.7746 42.9278C31.7746 43.2787 31.6261 43.6295 31.3831 43.8859ZM31.6666 38.7176C31.5991 38.8796 31.5046 39.028 31.3831 39.163C31.2481 39.2844 31.0996 39.3789 30.9376 39.4463C30.7756 39.5138 30.6001 39.5543 30.4246 39.5543C30.2491 39.5543 30.0737 39.5138 29.9117 39.4463C29.7497 39.3789 29.6012 39.2844 29.4662 39.163C29.3447 39.028 29.2502 38.8796 29.1827 38.7176C29.1152 38.5557 29.0747 38.3803 29.0747 38.2049C29.0747 38.0294 29.1152 37.854 29.1827 37.6921C29.2502 37.5302 29.3447 37.3817 29.4662 37.2468C29.6012 37.1253 29.7497 37.0309 29.9117 36.9634C30.2356 36.8285 30.6136 36.8285 30.9376 36.9634C31.0996 37.0309 31.2481 37.1253 31.3831 37.2468C31.5046 37.3817 31.5991 37.5302 31.6666 37.6921C31.7341 37.854 31.7746 38.0294 31.7746 38.2049C31.7746 38.3803 31.7341 38.5557 31.6666 38.7176ZM36.1079 39.163C35.9729 39.2844 35.8244 39.3789 35.6624 39.4463C35.5004 39.5138 35.3249 39.5543 35.1494 39.5543C34.9739 39.5543 34.7984 39.5138 34.6364 39.4463C34.4744 39.3789 34.3259 39.2844 34.191 39.163C33.948 38.9066 33.7995 38.5557 33.7995 38.2049C33.7995 37.854 33.948 37.5032 34.191 37.2468C34.3259 37.1253 34.4744 37.0309 34.6364 36.9634C34.9604 36.815 35.3384 36.815 35.6624 36.9634C35.8244 37.0309 35.9729 37.1253 36.1079 37.2468C36.3509 37.5032 36.4993 37.854 36.4993 38.2049C36.4993 38.5557 36.3509 38.9066 36.1079 39.163Z" fill="#24A4EC"/>
                    </svg>
                </div>
                <div class="wpc-overview-content">
                    <p><?php echo esc_html__('Reservations', 'wpcafe' ) ?></p>
                    <h3 class="wpc-count"><?php echo esc_html($performance['booking'])?></h3>
                </div>
            </div>
        </div>
        
        <div class="wpc-col-lg-3 wpc-col-md-6">
            <div class="wpc-performance-item">
                <div class="wpc-overview-icon">
                <svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle opacity="0.17" cx="35" cy="35" r="35" fill="#FF6B00"/>
                    <path d="M33.9497 29.5122V33.5162L32.5357 33.0262C31.8217 32.7742 31.3877 32.5362 31.3877 31.3182C31.3877 30.3242 32.1297 29.5122 33.0397 29.5122H33.9497Z" fill="#F07B27"/>
                    <path d="M38.6118 38.6824C38.6118 39.6764 37.8698 40.4884 36.9598 40.4884H36.0498V36.4844L37.4638 36.9744C38.1778 37.2264 38.6118 37.4644 38.6118 38.6824Z" fill="#F07B27"/>
                    <path d="M40.866 21H29.134C24.038 21 21 24.038 21 29.134V40.866C21 45.962 24.038 49 29.134 49H40.866C45.962 49 49 45.962 49 40.866V29.134C49 24.038 45.962 21 40.866 21ZM38.164 35C39.256 35.378 40.712 36.176 40.712 38.682C40.712 40.838 39.032 42.588 36.96 42.588H36.05V43.4C36.05 43.974 35.574 44.45 35 44.45C34.426 44.45 33.95 43.974 33.95 43.4V42.588H33.446C31.15 42.588 29.288 40.642 29.288 38.262C29.288 37.688 29.75 37.212 30.338 37.212C30.912 37.212 31.388 37.688 31.388 38.262C31.388 39.494 32.312 40.488 33.446 40.488H33.95V35.742L31.836 35C30.744 34.622 29.288 33.824 29.288 31.318C29.288 29.162 30.968 27.412 33.04 27.412H33.95V26.6C33.95 26.026 34.426 25.55 35 25.55C35.574 25.55 36.05 26.026 36.05 26.6V27.412H36.554C38.85 27.412 40.712 29.358 40.712 31.738C40.712 32.312 40.25 32.788 39.662 32.788C39.088 32.788 38.612 32.312 38.612 31.738C38.612 30.506 37.688 29.512 36.554 29.512H36.05V34.258L38.164 35Z" fill="#F07B27"/>
                </svg>

                </div>
                <div class="wpc-overview-content">
                    <p><?php echo esc_html__('Total Sales', 'wpcafe' ) ?></p>
                    <h3 class="wpc-count"><?php esc_html_e( $currency_symbol . $performance['sales'])?></h3>
                </div>
            </div>
        </div>
        
        <div class="wpc-col-lg-3 wpc-col-md-6">
            <div class="wpc-performance-item">
                <div class="wpc-overview-icon">
                    <svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle opacity="0.15" cx="35" cy="35" r="35" fill="#01AF28"/>
                        <path d="M35.9497 27.5122V31.5162L34.5357 31.0262C33.8217 30.7742 33.3877 30.5362 33.3877 29.3182C33.3877 28.3242 34.1297 27.5122 35.0397 27.5122H35.9497Z" fill="#1DBE41"/>
                        <path d="M40.6118 36.6824C40.6118 37.6764 39.8698 38.4884 38.9598 38.4884H38.0498V34.4844L39.4638 34.9744C40.1778 35.2264 40.6118 35.4644 40.6118 36.6824Z" fill="#1DBE41"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M31.134 19H42.866C47.962 19 51 22.038 51 27.134V38.866C51 43.962 47.962 47 42.866 47H31.9451C31.4477 42.5003 27.6329 39.0004 23.0007 39C23.0002 38.9555 23 38.9108 23 38.866V27.134C23 22.038 26.038 19 31.134 19ZM42.712 36.682C42.712 34.176 41.256 33.378 40.164 33L38.05 32.258V27.512H38.554C39.688 27.512 40.612 28.506 40.612 29.738C40.612 30.312 41.088 30.788 41.662 30.788C42.25 30.788 42.712 30.312 42.712 29.738C42.712 27.358 40.85 25.412 38.554 25.412H38.05V24.6C38.05 24.026 37.574 23.55 37 23.55C36.426 23.55 35.95 24.026 35.95 24.6V25.412H35.04C32.968 25.412 31.288 27.162 31.288 29.318C31.288 31.824 32.744 32.622 33.836 33L35.95 33.742V38.488H35.446C34.312 38.488 33.388 37.494 33.388 36.262C33.388 35.688 32.912 35.212 32.338 35.212C31.75 35.212 31.288 35.688 31.288 36.262C31.288 38.642 33.15 40.588 35.446 40.588H35.95V41.4C35.95 41.974 36.426 42.45 37 42.45C37.574 42.45 38.05 41.974 38.05 41.4V40.588H38.96C41.032 40.588 42.712 38.838 42.712 36.682Z" fill="#1DBE41"/>
                        <path d="M23 41C21.215 41 19.57 41.6825 18.3275 42.8025C18.0475 43.0475 17.785 43.31 17.5575 43.6075C16.5775 44.815 16 46.3375 16 48C16 51.8675 19.15 55 23 55C24.68 55 26.2025 54.405 27.41 53.4425C28.39 52.62 29.16 51.5525 29.58 50.3275C29.86 49.61 30 48.8225 30 48C30 44.15 26.8675 41 23 41ZM27.1475 51.0625C27.095 51.15 27.025 51.255 26.955 51.325L25.695 52.5675C25.5375 52.7425 25.31 52.83 25.1 52.83C24.8725 52.83 24.645 52.76 24.4875 52.585C24.2075 52.3225 24.1725 51.9025 24.3475 51.5875H20.83C19.71 51.5875 18.8 50.6775 18.8 49.54V49.365C18.8 48.875 19.185 48.5075 19.6575 48.5075C20.13 48.5075 20.515 48.875 20.515 49.365V49.54C20.515 49.7325 20.655 49.89 20.8475 49.89H24.365C24.19 49.5575 24.225 49.155 24.505 48.875C24.68 48.7175 24.89 48.63 25.1 48.63C25.31 48.63 25.5375 48.7175 25.695 48.875L26.955 50.135C27.025 50.205 27.095 50.31 27.1475 50.415C27.2175 50.625 27.2175 50.8525 27.1475 51.0625ZM26.3425 47.51C25.87 47.51 25.485 47.1425 25.485 46.6525V46.4775C25.485 46.285 25.345 46.1275 25.1525 46.1275H21.6525C21.8275 46.46 21.7925 46.8625 21.5125 47.1425C21.355 47.3 21.145 47.3875 20.9 47.3875C20.69 47.3875 20.4625 47.3 20.305 47.1425L19.045 45.8825C18.975 45.8125 18.905 45.7075 18.8525 45.6025C18.7825 45.3925 18.7825 45.165 18.8525 44.955C18.905 44.8675 18.9575 44.745 19.045 44.675L20.305 43.4325C20.4625 43.2575 20.69 43.17 20.9 43.17C21.11 43.17 21.3375 43.2575 21.495 43.4325C21.775 43.695 21.81 44.115 21.635 44.43H25.1525C26.2725 44.43 27.1825 45.34 27.1825 46.4775V46.6525H27.2C27.2 47.1425 26.815 47.51 26.3425 47.51Z" fill="#1DBE41"/>
                    </svg>

                </div>
                <div class="wpc-overview-content">
                    <p><?php echo esc_html__('Refunds', 'wpcafe' ) ?></p>
                    <h3 class="wpc-count"><?php echo esc_html( $currency_symbol . $performance['refunds'])?></h3>
                </div>
            </div>
        </div>
        
        <div class="wpc-col-lg-3 wpc-col-md-6">
            <div class="wpc-performance-item">
                <div class="wpc-overview-icon">
                <svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle opacity="0.15" cx="35" cy="35" r="35" fill="#AD00FF"/>
                    <path d="M40.92 22.3335H29.7467C24.8933 22.3335 22 25.2268 22 30.0802V41.2535C22 45.0002 23.72 47.5735 26.7467 48.5468C27.6267 48.8535 28.64 49.0002 29.7467 49.0002H40.92C42.0267 49.0002 43.04 48.8535 43.92 48.5468C46.9467 47.5735 48.6667 45.0002 48.6667 41.2535V30.0802C48.6667 25.2268 45.7733 22.3335 40.92 22.3335ZM46.6667 41.2535C46.6667 44.1068 45.5467 45.9068 43.2933 46.6535C42 44.1068 38.9333 42.2935 35.3333 42.2935C31.7333 42.2935 28.68 44.0935 27.3733 46.6535H27.36C25.1333 45.9335 24 44.1202 24 41.2668V30.0802C24 26.3202 25.9867 24.3335 29.7467 24.3335H40.92C44.68 24.3335 46.6667 26.3202 46.6667 30.0802V41.2535Z" fill="#AB2BE7"/>
                    <path d="M35.3358 30.3335C32.6958 30.3335 30.5625 32.4668 30.5625 35.1068C30.5625 37.7468 32.6958 39.8935 35.3358 39.8935C37.9758 39.8935 40.1092 37.7468 40.1092 35.1068C40.1092 32.4668 37.9758 30.3335 35.3358 30.3335Z" fill="#AB2BE7"/>
                    <circle cx="46" cy="26.3335" r="4" fill="white"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M45.9993 31.6667C48.9449 31.6667 51.3327 29.2789 51.3327 26.3333C51.3327 23.3878 48.9449 21 45.9993 21C43.0538 21 40.666 23.3878 40.666 26.3333C40.666 29.2789 43.0538 31.6667 45.9993 31.6667ZM45.0098 24.3442C45.0098 23.792 45.4575 23.3442 46.0098 23.3442C46.5621 23.3442 47.0098 23.792 47.0098 24.3442V25.3442H48.0098C48.5621 25.3442 49.0098 25.792 49.0098 26.3442C49.0098 26.8965 48.5621 27.3442 48.0098 27.3442H47.0098V28.3442C47.0098 28.8965 46.5621 29.3442 46.0098 29.3442C45.4575 29.3442 45.0098 28.8965 45.0098 28.3442V27.3442H44.0098C43.4575 27.3442 43.0098 26.8965 43.0098 26.3442C43.0098 25.792 43.4575 25.3442 44.0098 25.3442H45.0098V24.3442Z" fill="#AB2BE7"/>
                </svg>

                </div>
                <div class="wpc-overview-content">
                    <p><?php echo esc_html__('New Customers', 'wpcafe' ); ?></p>
                    <h3 class="wpc-count"><?php esc_html_e($performance['clients'])?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="wpc-admin-sec wpc-overview-sec">
    <div class="wpc-row wpc-align-items-center">
        <div class="wpc-col-md-7">
            <h2 class="wpc-heading"><?php echo esc_html__('Reports', 'wpcafe' ); ?></h2>
        </div>
        <div class="wpc-col-md-5">
            <div class="wpc-label-item wpc-report-item wpc-mb-0">

                <div class="wpc-meta">
                    <label class="wpc-label-top"><?php echo esc_html__('Channel','wpcafe'); ?></label>
                    <select class="wpc-settings-input wpc_chart_type wpc-input-dark">
                        <option value="reservations"><?php echo esc_html__('Reservations', 'wpcafe'); ?></option>
                        <option value="food_ordering"><?php echo esc_html__('Food Ordering', 'wpcafe'); ?></option>
                    </select>
                </div>

                <div class="wpc-meta wpc-meta-double-date">
                    <label class="wpc-label-top"><?php echo esc_html__('Timeline','wpcafe'); ?></label>
                    <input type="text" value="" data-date_range="" class="wpc_date_picker wpc-settings-input attr-form-control" id="" placeholder="<?php esc_attr_e('April 01, '.date("Y").' - April 31, '.date("Y").'', 'wpcafe' ); ?>" />
                </div>

            </div>
        </div>
    </div>
    <div class="wpc-row">
        <div class="wpc-col-12">
            <div id="wpc_chart_wrap">
                <canvas id="wpc_over_view"></canvas>
            </div>
        </div>
    </div>
</div>