<?php

$default_banner_bg = CUINARE_IMG . '/banner/banner_bg.png';


$cuinare_banner_option      = cuinare_option( 'shop_banner_settings' );
$cuinare_banner_show        = isset( $cuinare_banner_option['show'] ) ? $cuinare_banner_option['show'] : true;
$cuinare_breadcrumb_show    = isset( $cuinare_banner_option['show_breadcrumb'] ) ? $cuinare_banner_option['show_breadcrumb'] : false;
$cuinare_page_title         = ! empty( $cuinare_banner_option['shop_banner_title'] ) ? $cuinare_banner_option['shop_banner_title'] : esc_html__( 'Shop', 'cuinare' );
$cuinare_banner_image       = ! empty( $cuinare_banner_option['banner_shop_image']['url'] ) ? $cuinare_banner_option['banner_shop_image']['url'] : $default_banner_bg;

if ( $cuinare_banner_image != '' ) {
	$cuinare_banner_image = 'style="background-image:url(' . esc_url( $cuinare_banner_image ) . ');"';
}

?>
<?php if ( $cuinare_banner_show == true ): ?>

    <section
            class="banner-shop banner-area <?php echo esc_attr( $cuinare_banner_image == '' ? 'banner-solid' : 'banner-bg' ); ?>" <?php echo cuinare_kses( $cuinare_banner_image ); ?>>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="banner-heading text-center">
                            <h1>
								<?php
								if ( is_shop() ) {
									if ( isset( $cuinare_page_title ) ) {
										echo cuinare_kses( $cuinare_page_title );
									} 
								} elseif ( is_product() ) {
									echo cuinare_kses( $cuinare_single_title );
								} else {
									echo cuinare_kses( $cuinare_single_title );
								}
								?>
                            </h1>
						<?php endif; ?>
						<?php if ( $cuinare_breadcrumb_show == true ): ?>
							<?php cuinare_get_breadcrumbs( " " ); ?>
						<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>




