(function ($, elementor) {
   "use strict";

   var Cuinare = {

       init: function () {

           var widgets = {
               'cuinare-client-logo.default': Cuinare.Client_Logo,
               'advanced-slider.default': Cuinare.AdvancedSlider,
               'product-category-slider.default': Cuinare.Cuinare_Product_Category_Slider,
               'multivendor-product-slider.default': Cuinare.Cuinare_Multivendor_Product_Slider,
           };
           $.each(widgets, function (widget, callback) {
               elementor.hooks.addAction('frontend/element_ready/' + widget, callback);
           });

       },

      Client_Logo: function( $scope ) {
         var $el = $scope.find( '.elementskit-clients-slider' ),
            config = $el.data( 'config' );

         // Arrows
         if ( config.arrows ) {
            config.navigation = {
               prevEl: $scope.find( '.slick-prev' ),
               nextEl: $scope.find( '.slick-next' ),
            };
         }

         // pagination
         if ( config.dots ) {
            config.pagination = {
               el: $scope.find( '.swiper-pagination' ),
               type: 'custom',
               clickable: true,
               renderCustom: ( swiper, current, total ) => {
                  var pagination = '';
                  for ( let i = 1; i <= total; i++ ) {
                     pagination += '<li role="presentation" class="'+ (current === i ? " swiper-pagination-bullet-active slick-active" :  "swiper-pagination-bullet") +'"><button type="button" role="tab"  tabindex="0" aria-selected="true" class="">'+  i +'</button></li>';
                  }
                  return pagination;
               }
            }
         }

         // swiper
         let swiper = new Swiper( $scope.find( '.swiper-container' ), config );

         // pause on hover
         if ( config.autoplay && config.pauseOnHover ) {
            $scope.find( '.swiper-container' ).hover( function() {
               swiper.autoplay.stop();
            }, function() {
               swiper.autoplay.start();
            } );
         }
      }, 

      // Product Category Slider
      Cuinare_Product_Category_Slider: function( $scope ) {
         let $container = $scope.find( '.category-slider' );
         if ( $container.length > 0 ) {
            let controls = $container.data( 'controls' );
            let autoslide = Boolean(controls.autoplay_slide === 'yes' ?true:false);
            let slider_items = controls.slider_items;
            let slider_space_between = controls.slider_item_gap;
            let slider_loop = (controls.slider_loop === 'yes') ? true : false;
            let widget_id = controls.widget_id;
            
            // eslint-disable-next-line
            $($container).each(function (index, element) {
               let $element = $( element ).find( '.swiper-container' );
               new Swiper( $element, {
                  spaceBetween: slider_space_between,
                  initialSlide: 1,
                  loop: slider_loop,
                  slidesPerView: parseInt(slider_items),
                  wrapperClass: 'swiper-wrapper',
                  speed: 1200, //slider transition speed
                  parallax: true,
                  autoplay: autoslide,
                  navigation: {
                     nextEl: `.swiper-next-${widget_id}`,
                     prevEl: `.swiper-prev-${widget_id}`,
                  },
                  breakpoints: {
                     0: {
                        slidesPerView: 1,
                     },
                     767: {
                        slidesPerView: 3,
                     },
                     1024: {
                        slidesPerView: parseInt(slider_items),
                     },
                  },
               });
            });
          }
      },


      // Multivendor Product Slider
      cuinare_Product_Slider: function( $scope ) {
         let $container = $scope.find( '.cuinare-product-slider' );
            if ( $container.length > 0 ) {
            let controls = $container.data( 'controls' );
            let autoslide = Boolean(controls.autoplay_slide === 'yes' ?true:false);
            let slider_items = controls.slider_items;
            let slider_space_between = controls.slider_item_gap;
            let slider_loop = (controls.slider_loop === 'yes') ? true : false;
            let widget_id = controls.widget_id;
            
            // eslint-disable-next-line
            $($container).each(function (index, element) {
               let $element = $( element ).find( '.swiper-container' );
               new Swiper( $element, {
                  spaceBetween: slider_space_between,
                  initialSlide: 1,
                  loop: slider_loop,
                  slidesPerView: parseInt(slider_items),
                  wrapperClass: 'swiper-wrapper',
                  speed: 1200, //slider transition speed
                  parallax: true,
                  autoplay: autoslide,
                  navigation: {
                     nextEl: `.swiper-next-${widget_id}`,
                     prevEl: `.swiper-prev-${widget_id}`,
                  },
                  breakpoints: {
                     0: {
                        slidesPerView: 1,
                     },
                     767: {
                        slidesPerView: 2,
                     },
                     1024: {
                        slidesPerView: parseInt(slider_items),
                     },
                  },
               });
            });
         }
      },

      
      AdvancedSlider: function( $scope ) {
			var el = $scope.find( '.cuinare-slider-wrapper' );
			var effect = el.attr( 'data-effect' );
			var settings = $scope.find( '.cuinare-advanced-slider' ).data( 'widget_settings' );
			var slide_autoplay = ( settings.ts_slider_autoplay === 'yes' ) ? true : false;
			var ts_slider_loop = ( settings.ts_slider_loop === 'yes' ) ? true : false;
			var ts_slider_speed = parseInt( settings.ts_slider_speed );
			new Swiper( el, {
				speed: ts_slider_speed,
				slidesPerView: 1,
				spaceBetween: 30,
				effect: effect,
				autoplay: slide_autoplay ? { delay: settings.ts_slider_autoplay_delay } : false,
				paginationClickable: true,
				loop: ts_slider_loop,
				autoHeight: true,
            centeredSlides: true,
				pagination: {
					el: '.swiper-pagination',
					clickable: true,
					type: 'bullets',
				},

            breakpoints: {
               0: {
                  slidesPerView: 1,
               },
               767: {
                  slidesPerView: 1,
               },
               1024: {
                  slidesPerView: 1,
               },
            },

				navigation: {
					nextEl: `.swiper-next-${settings.widget_id}`,
					prevEl: `.swiper-prev-${settings.widget_id}`,
				},
			} );
		},

      // Multivendor Product Slider
      Cuinare_Multivendor_Product_Slider: function( $scope ) {
         let $container = $scope.find( '.multivendor-product-slider' );
          if ( $container.length > 0 ) {
            let controls = $container.data( 'controls' );
            let autoslide = Boolean(controls.autoplay_slide === 'yes' ?true:false);
            let slider_items = controls.slider_items;
            let slider_space_between = controls.slider_item_gap;
            let slider_loop = (controls.slider_loop === 'yes') ? true : false;
            let widget_id = controls.widget_id;
            
            // eslint-disable-next-line
            $($container).each(function (index, element) {
               let $element = $( element ).find( '.swiper-container' );
               new Swiper( $element, {
                  spaceBetween: slider_space_between,
                  initialSlide: 1,
                  loop: slider_loop,
                  slidesPerView: parseInt(slider_items),
                  wrapperClass: 'swiper-wrapper',
                  speed: 1200, //slider transition speed
                  parallax: true,
                  autoplay: autoslide,
                  navigation: {
                     nextEl: `.swiper-next-${widget_id}`,
                     prevEl: `.swiper-prev-${widget_id}`,
                  },
                  breakpoints: {
                     0: {
                        slidesPerView: 1,
                     },
                     767: {
                        slidesPerView: 2,
                     },
                     1024: {
                        slidesPerView: parseInt(slider_items),
                     },
                  },
               });
            });
         }
      },
     
   };
   $(window).on('elementor/frontend/init', Cuinare.init);
}(jQuery, window.elementorFrontend));


