<?php
namespace Elementor;

if (!defined('ABSPATH')) exit;

class Product_Category_Slider extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'product-category-slider';
    }

    public function get_title()
    {
        return esc_html__('Product Category Slider', 'cuinare');
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['cuinare-elements'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Category Slider Settings', 'cuinare'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'slider_items',
            [
                'label'         => esc_html__('Slide Items', 'cuinare'),
                'type'          => Controls_Manager::NUMBER,
                'default'       => 5
            ]
        );
        
        $this->add_control(
            'post_cats',
            [
                'label' => esc_html__('Select Categories', 'cuinare'),
                'type'      => Controls_Manager::SELECT2,
                'options'   => $this->post_category(),
                'label_block' => true,
                'multiple'  => true
            ]
        );

        $this->add_control(
            'ts_slider_loop',
            [
                'label' => esc_html__( 'Loop', 'cuinare' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'cuinare' ),
                'label_off' => esc_html__( 'No', 'cuinare' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'ts_slider_autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'cuinare' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'cuinare' ),
                'label_off' => esc_html__( 'No', 'cuinare' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        
        $this->add_control(
            'show_navigation',
            [
                'label'       => esc_html__('Show Navigation', 'cuinare'),
                'type'        => Controls_Manager::SWITCHER,
                'label_on'    => esc_html__('Yes', 'cuinare'),
                'label_off'   => esc_html__('No', 'cuinare'),
                'default'     => 'yes'
            ]
        );

        $this->add_control(
			'left_arrow_icon',
			[
				'label' => esc_html__( 'Left Arrow Icon', 'cuinare' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-l-arrow',
					'library' => 'solid',
				],
                'condition' => ['show_navigation' => 'yes']
			]
		);

        $this->add_control(
			'right_arrow_icon',
			[
				'label' => esc_html__( 'Right Arrow Icon', 'cuinare' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-right-arrow',
					'library' => 'solid',
				],
                'condition' => ['show_navigation' => 'yes']
			]
		);

        
        $this->add_control(
            'slider_space_between',
            [
                'label'         => esc_html__('Slider Item Space', 'cuinare'),
                'description'   => esc_html__('Space between slides', 'cuinare'),
                'type'          => Controls_Manager::NUMBER,
                'return_value'  => 'yes',
                'default'       => 30
            ]
        );
        $this->end_controls_section();

        // Category slider style controller
        $this->start_controls_section(
            'cuinare_style_block_section',
            [
                'label' => esc_html__('Category Slider Style', 'cuinare'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_settings',
            [
                'label' => __('Title Style', 'cuinare'),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
          'title_style_normal_tab',
          [
            'label' => __( 'Normal', 'cuinare' ),
          ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-slider-wrapper .cat-name' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
          'title_style_hover_tab',
          [
            'label' => __( 'Hover', 'cuinare' ),
          ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('Title hover color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-slider-wrapper:hover .cat-name' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .category-slider-wrapper .cat-name',
			]
       );

        $this->add_responsive_control(
            'title_text_align',
            [
                'label' => __('Title Alignment', 'cuinare'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'cuinare'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'cuinare'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'cuinare'),
                        'icon' => 'fa fa-align-right',
                    ]
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .category-slider-wrapper .cat-name' => 'text-align:{{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'cuinare'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
                'default'   => [
					'top' => '15px',
					'right' => '0',
					'bottom' => '0',
					'left' => '20px',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .category-slider-wrapper .cat-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();


        // Slider Nav controls start
        $this->start_controls_section(
			'slider_section_style',
			[
				'label' => esc_html__( 'Slider Nav Style', 'cuinare' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_navigation' => 'yes']
			]
		);
        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'width', 'cuinare' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' , '%' ],
				'range' => [
					'%' => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
			
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'width: {{SIZE}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
			'icon_height',
			[
				'label' => esc_html__( 'Height', 'cuinare' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' , '%' ],
				'range' => [
					'%' => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
			
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->start_controls_tabs(
            'navigation_style_tabs'
        );
        
        $this->start_controls_tab(
          'navigation_style_normal_tab',
          [
            'label' => __( 'Normal', 'cuinare' ),
          ]
        );
        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Icon Background Color', 'cuinare' ),
                'default' => '#E4E8F8',
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_nav_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
          'navigation_style_hover_tab',
          [
            'label' => __( 'Hover', 'cuinare' ),
          ]
        );
        $this->add_control(
			'icon_color_hover',
			[
				'label' => esc_html__( 'Icon Hover Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'icon_bg_color_hover',
			[
				'label' => esc_html__( 'Icon Hover Background Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
                'default' => '#EE4D4D',
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_hover_nav_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => esc_html__( 'Typography', 'cuinare' ),
				'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
			]
		);

        $this->add_responsive_control(
			'nav_border_radius',
			[
				'label' => esc_html__( 'Nav Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_prev_position',
			[
				'label'       => esc_html__('Previous Button Position (x-axis)', 'cuinare'),
				'description' => esc_html__('(-) Negative values are allowed', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => -100,
						'max' => 200,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-prev' => 'transform: translate({{SIZE}}{{UNIT}});',
				],
			]
		);

        $this->add_responsive_control(
			'slide_next_position',
			[
				'label'       => esc_html__('Next Button Position (x-axis)', 'cuinare'),
				'description' => esc_html__('(-) Negative values are allowed', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => -100,
						'max' => 200,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-next' => 'transform: translate({{SIZE}}{{UNIT}});',
				],
			]
		);
        $this->end_controls_section();


        // Slider Wrapper controls start
        $this->start_controls_section(
			'slider_wrapper_section_style',
			[
				'label' => esc_html__( 'Slider Wrapper Style', 'cuinare' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs(
            'slider_wrapper_style_tabs'
        );

        $this->start_controls_tab(
            'slider_wrapper_style_normal_tab',
            [
              'label' => __( 'Normal', 'cuinare' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_wrapper_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .category-slider-wrapper',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'slider_wrapper_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'cuinare' ),
				'selector' => '{{WRAPPER}} .category-slider-wrapper',
			]
		);


        $this-> end_controls_tab();

        $this->start_controls_tab(
            'slider_wrapper_style_hover_tab',
            [
              'label' => __( 'Hover', 'cuinare' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_wrapper_hover_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .category-slider-wrapper:hover',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'slider_wrapper_box_shadow_hover',
				'label' => esc_html__( 'Box Shadow On Hover', 'cuinare' ),
				'selector' => '{{WRAPPER}} .category-slider-wrapper:hover',
			]
		);

        $this-> end_controls_tab();

        $this-> end_controls_tabs();

        $this-> end_controls_section();

        

        
    }

    public function post_category(){
        $terms = get_terms(array(
            'taxonomy'    => 'product_cat',
            'hide_empty'  => false,
            'posts_per_page' => -1,
        ));

        $cat_list = [];
        foreach ($terms as $post) {
            $cat_list[$post->term_id]  = [$post->name];
        }
        return $cat_list;
    }
    

    protected function render( ) {

        $settings          =    $this->get_settings();
        $category_ids      =    $settings['post_cats'];

        $args = array(
            'taxonomy'     => 'product_cat',
            'orderby'      => 'name',
            'hide_empty'   => 0
        );

        if(!empty($category_ids)){
            $args['include'] = $category_ids;
        }

        $all_categories = get_terms($args);
        $show_navigation   =         $settings["show_navigation"]=="yes"?true:false;
        $autoplay_slider    =         $settings['ts_slider_autoplay'];
        $slider_items       =         $settings['slider_items'];
        $slider_item_gap   =         $settings['slider_space_between'];
        $slider_loop       =         $settings['ts_slider_loop'];

        $slide_controls    = [
            'slider_loop' => $slider_loop,
            'autoplay_slide'=> $autoplay_slider, 
            'show_nav'=>$show_navigation, 
            'slider_items' => $slider_items,
            'slider_item_gap' => $slider_item_gap,
            'widget_id' => $this->get_id()
        ];
        $slide_controls = \json_encode($slide_controls); 
      ?>
    <?php if(!empty($all_categories)) { ?>
        <div class="category-slider" data-controls="<?php echo esc_attr($slide_controls); ?>">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    <?php  foreach ( $all_categories as $cat):

                        $term = get_term($cat, 'product_cat');
                        $image_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                        $cat_name = esc_html($cat->name);

                    ?>

                    <div class="swiper-slide">
                        <div class="category-slider-wrapper">
                            <a href="<?php echo esc_url(get_term_link($cat->slug, 'product_cat')); ?>">
                                <div class="cat-img">
                                    <?php if(!empty($image_id) && $image_id != ''):  ?>
                                    <?php echo wp_get_attachment_image($image_id, 'full'); ?>
                                    <?php endif; ?>
                                </div>
                                <h2 class="cat-name"><?php echo esc_html($cat_name); ?></h2>
                            </a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <!-- Next Previous Arrow -->
            <?php if($show_navigation =='yes'){ ?>
                <!-- next / prev arrows -->
                <div class="swiper-button-next swiper-next-<?php echo esc_attr($this->get_id()); ?>" > 
                    <?php \Elementor\Icons_Manager::render_icon( $settings['right_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <div class="swiper-button-prev swiper-prev-<?php echo esc_attr($this->get_id()); ?>">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['left_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <?php } ?>
        </div>
    <?php
    }
    }
    protected function content_template() { }
}
