<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Customizer Option: Blog
 */

CSF::createSection( $prefix, [
	'parent' => 'theme_settings',
	'title'  => esc_html__( 'Blog Settings', 'cuinare' ),
	'fields' => [
		[
			'id'      => 'post_layout',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Post layout', 'cuinare' ),
			'desc'    => esc_html__( 'blog post\'s layout style.', 'cuinare' ),
			'options' => array(
				'style1' => CUINARE_IMG . '/admin/post-layout/style1.png'
			),
			'default' => 'style1'
		],
		[
			'id'       => 'blog_sidebar',
			'type'     => 'select',
			'multiple' => false,
			'label'    => esc_html__( 'Blog Sidebar', 'cuinare' ),
			'desc'     => esc_html__( 'Select blog sidebar', 'cuinare' ),
			'options'  => array(
				'1' => esc_html__( 'No sidebar', 'cuinare' ),
				'2' => esc_html__( 'Left Sidebar', 'cuinare' ),
				'3' => esc_html__( 'Right Sidebar', 'cuinare' ),
			),
			'default'  => '3'
		],
		[
			'id'       => 'blog_author',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Blog author', 'cuinare' ),
			'subtitle' => esc_html__( 'Do you want to show blog author?', 'cuinare' ),
			'default'  => true,
			'text_on'  => esc_html__( 'Yes', 'cuinare' ),
			'text_off' => esc_html__( 'No', 'cuinare' ),
		],
		[
			'id'       => 'blog_related_post',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Blog related post', 'cuinare' ),
			'subtitle' => esc_html__( 'Do you want to show single blog related post?', 'cuinare' ),
			'default'  => false,
			'text_on'  => esc_html__( 'Yes', 'cuinare' ),
			'text_off' => esc_html__( 'No', 'cuinare' ),
		],
		[
			'id'      => 'blog_related_post_number',
			'type'    => 'text',
			'title'   => esc_html__( 'Related post count', 'cuinare' ),
			'default' => '3'
		],
		[
			'id'       => 'blog_meta_post',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Blog post meta', 'cuinare' ),
			'subtitle' => esc_html__( 'Do you want to show blog meta?', 'cuinare' ),
			'default'  => true,
			'text_on'  => esc_html__( 'Yes', 'cuinare' ),
			'text_off' => esc_html__( 'No', 'cuinare' ),
		],
	],
] );