<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class CUINARE_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	 */

	public static function get_icons() {

		$icons = array(
         'tsicon tsicon-tripadvisor_icon' => 'tsicon tsicon-tripadvisor_icon',
         'tsicon tsicon-twitter-icon' => 'tsicon tsicon-twitter-icon',
         'tsicon tsicon-arrow_icon' => 'tsicon tsicon-arrow_icon',
         'tsicon tsicon-clock-icon' => 'tsicon tsicon-clock-icon',
         'tsicon tsicon-down-arrow' => 'tsicon tsicon-down-arrow',
         'tsicon tsicon-down-arrow2' => 'tsicon tsicon-down-arrow2',
         'tsicon tsicon-facebook-icon' => 'tsicon tsicon-facebook-icon',
         'tsicon tsicon-faq1' => 'tsicon tsicon-faq1',
         'tsicon tsicon-faq2' => 'tsicon tsicon-faq2',
         'tsicon tsicon-faq3' => 'tsicon tsicon-faq3',
         'tsicon tsicon-faq4' => 'tsicon tsicon-faq4',
         'tsicon tsicon-instagram-icon' => 'tsicon tsicon-instagram-icon',
         'tsicon tsicon-l-arrow' => 'tsicon tsicon-l-arrow',
         'tsicon tsicon-left-solid-arrow' => 'tsicon tsicon-left-solid-arrow',
         'tsicon tsicon-linkedin-icon' => 'tsicon tsicon-linkedin-icon',
         'tsicon tsicon-map_icon' => 'tsicon tsicon-map_icon',
         'tsicon tsicon-phone-icon' => 'tsicon tsicon-phone-icon',
         'tsicon tsicon-right-arrow' => 'tsicon tsicon-right-arrow',
         'tsicon tsicon-right-solid-arrow' => 'tsicon tsicon-right-solid-arrow',
         'tsicon tsicon-rocket-solid' => 'tsicon tsicon-rocket-solid',
         'tsicon tsicon-comment-regular' => 'tsicon tsicon-comment-regular',
         'tsicon tsicon-user-solid' => 'tsicon tsicon-user-solid',
         'tsicon tsicon-layer-group-solid' => 'tsicon tsicon-layer-group-solid',
         'tsicon tsicon-down_arrow2' => 'tsicon tsicon-down_arrow2',
         'tsicon tsicon-grid_view' => 'tsicon tsicon-grid_view',
         'tsicon tsicon-list_view' => 'tsicon tsicon-list_view',
         'tsicon tsicon-map_icon2' => 'tsicon tsicon-map_icon2',
         'tsicon tsicon-menu' => 'tsicon tsicon-menu',
         'tsicon tsicon-phone-icon2' => 'tsicon tsicon-phone-icon2',
         'tsicon tsicon-quote' => 'tsicon tsicon-quote',
         'tsicon tsicon-review' => 'tsicon tsicon-review',
         'tsicon tsicon-search' => 'tsicon tsicon-search',
         'tsicon tsicon-wishlist' => 'tsicon tsicon-wishlist',
         'tsicon tsicon-zoom' => 'tsicon tsicon-zoom',
         'tsicon tsicon-bars-solid' => 'tsicon tsicon-bars-solid',
         'tsicon tsicon-cart' => 'tsicon tsicon-cart',
         'tsicon tsicon-date' => 'tsicon tsicon-date',
         'tsicon tsicon-user' => 'tsicon tsicon-user',
         'tsicon tsicon-category' => 'tsicon tsicon-category',
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">

				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'cuinare' ); ?>">

					<option value=""><?php esc_html_e( 'Select Icon', 'cuinare' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}

}
