<?php
/*
Plugin Name: Dokan Store Carousel
Plugin URI: https://github.com/sohanHossainNabil
Description: Create carousels of Dokan stores based on store category
Version: 1.0.0
Author: Sohan Hossain Nabil
Author URI: https://facebook.com/sohan.hossain
License: GPLv2 or later
Text Domain: dokan-store-carousel
*/

/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

if( ! defined( 'ABSPATH' )	) {
	die;
}


define( 'SC_DOKANSC_URL', plugins_url( '/', __FILE__ ) );
define( 'SC_DOKANSC_PATH', plugin_dir_path( __FILE__ ) );
define( 'SC_DOKANSC_PLUGIN_NAME','Dokan Stores Carousel for Dokan');
require_once(SC_DOKANSC_PATH.'inc/class.sc-dependency-checker.php');

class DokanStoreCarousel 
{	
	function __construct() {
		// register shortcode
		add_shortcode( 'store_carousel', array( $this, 'create_carousel_shortcode' ) );

	}

	function register() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ) );
	}

	function activate() {
		// generated shortcode
		// flush rewrite rules
		flush_rewrite_rules();
	}

	function deactivate() {
		flush_rewrite_rules();
	}

	function uninstall() {

	}

	function enqueue() {
		// ennque necessary scripts
		wp_enqueue_style( 'dokancarouseluikit-rtl-css', plugins_url('/assets/css/uikit-rtl.min.css', __FILE__) );
		wp_enqueue_style( 'dokancarouseluikit-css', plugins_url('/assets/css/uikit.min.css', __FILE__) );
		wp_enqueue_script( 'dokancarouseluikit-icon-js', plugins_url('/assets/js/uikit-icons.min.js', __FILE__) );
		wp_enqueue_script( 'dokancarouseluikit-js', plugins_url('/assets/js/uikit.min.js', __FILE__) );
		wp_enqueue_script( 'dokancarouseluikit--iconjs', plugins_url('/assets/js/uikit-icons.min.js', __FILE__) );
	}

	// function that runs when shortcode is called
	function create_carousel_shortcode($attr) {

		$args = shortcode_atts( array(
		     
		            'name' => 'Uncategorized',
		         
		        ), $attr ); 

		$defaults = array(
            'role__in'   => array( 'seller', 'administrator' ),
            'number'     => -1,
            'offset'     => 0,
            'orderby'    => 'registered',
            'order'      => 'ASC',
            'status'     => 'approved',
            'featured'   => '', // yes or no
            'meta_query' => array(),
        );


		$sellers=dokan_get_sellers($defaults);
		?>

		<div class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></div>


		<div class="uk-position-relative uk-visible-toggle uk-dark " tabindex="-1" uk-slider="clsActivated: uk-transition-active; center: true">

		    <div class="uk-slider-items uk-grid">
		    	<?php

		        	foreach ( $sellers['users'] as $seller ) {
		                    $vendor            = dokan()->vendor->get( $seller->ID );
		                    $store_banner_id   = $vendor->get_banner_id();
		                    $store_name        = $vendor->get_shop_name();
		                    $store_url         = $vendor->get_shop_url();
		                    $store_rating      = $vendor->get_rating();
		                    $is_store_featured = $vendor->is_featured();
		                    $store_phone       = $vendor->get_phone();
		                    $store_info        = dokan_get_store_info( $seller->ID );
		                    $store_address     = dokan_get_seller_short_address( $seller->ID );
		                    $store_banner_url  = $store_banner_id ? wp_get_attachment_image_src( $store_banner_id, $image_size ) : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
		                    $store_cat = dokan()->vendor->get( $seller->id )->get_info_part('categories');

		           			for ($i=0; $i < count($store_cat) ; $i++) { 
		           				if(strtolower($store_cat[$i]->name) == strtolower($args['name'])): ?>

							        <div class="uk-width-3-4" style="width:400px ">
							            <div class="uk-panel">
							                <a href="<?php echo esc_url( $store_url ); ?>">
							                            <img src="<?php echo is_array( $store_banner_url ) ? esc_attr( $store_banner_url[0] ) : esc_attr( $store_banner_url ); ?>">
							                 </a>
							                <div class="uk-overlay uk-overlay-primary uk-position-bottom uk-text-center uk-transition-slide-bottom" style="height:10px !important;">
							                    <a style="color: white;" href="<?php echo esc_url( $store_url ); ?>"> <?php echo $store_name; ?></a>
							                </div>
							            </div>
							        </div>
							    <?php endif; 
		           			}
		                    
		        	} ?>
		        
		   </div>

		    <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
		    <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slider-item="next"></a>

		    <!-- <div class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></div> -->

		</div>
		<?php

		return;

	} 
}

$dependency=new SC_Dependency_Checker();
if($dependency->check()){
	if( class_exists('DokanStoreCarousel') ){
		$dokanCarousel = new DokanStoreCarousel();
		$dokanCarousel->register();
	}
}

// activation
register_activation_hook( __FILE__, array( $dokanCarousel, 'activate' ) );

// deactivation
register_deactivation_hook( __FILE__, array( $dokanCarousel, 'deactivate' ) );

// uninstall
