<?php
/**
 * The template for display additional products section
 *
 * @since 3.3.7
 *
 * @var string $section_id
 * @var string $section_title
 * @var \WeDevs\Dokan\Vendor\Vendor $vendor
 *
 */
$column_class = !empty($settings['column_class']) ? $settings['column_class'] : 'col-md-4';
?>

<?php do_action("dokan_store_before_{$section_id}_product_section", $vendor); ?>

<div id="dokan_store_section_<?php echo esc_attr($section_id); ?>" class="dokan-store-product-section">
    <h2 class="products-list-heading"><?php echo esc_html($section_title); ?></h2>
    <div class="seller-items">

		<?php woocommerce_product_loop_start(); ?>

		<?php while($products->have_posts()) : $products->the_post(); ?>
            <div class="row">
                <div class="<?php echo esc_attr($column_class); ?>">
                    <?php cuinare_multivendor_product_loop(get_the_ID(), 5); ?>
                </div>
            </div>

		<?php endwhile; ?>

		<?php woocommerce_product_loop_end(); ?>

		<?php wp_reset_postdata(); ?>

    </div>
</div>

<?php do_action("dokan_store_after_{$section_id}_product_section", $vendor); ?>

<?php 

// Product Sold
if(!function_exists('cuinare_product_sold_by')) {
    function cuinare_product_sold_by($product_id) {
    
        $seller = get_post_field('post_author', $product_id);
        $author = get_user_by('id', $seller);
        $vendor = dokan()->vendor->get($seller);
    
        $store_info = dokan_get_store_info($author->ID);
    
        if(!empty($store_info['store_name'])) : ?>
            <div class="store-name">
                <?php echo '<p>' . esc_html('Sold By:', 'cuinare') . '</p>'; ?>
                <a href="<?php echo esc_url($vendor->get_shop_url()); ?>"> <?php echo esc_html($vendor->get_shop_name()); ?></a>
            </div>
        <?php endif;
    
    }
}

add_filter('woocommerce_before_add_to_cart_quantity' , 'cuinare_product_sold_by', 30);
