<?php
/*
 * One Click Demo Import added
 * */
function cuinare_import_files() {
	$demo_content_installer = CUINARE_REMOTE_CONTENT;

	return [
		[
			'import_file_name'           => 'Cuinare Demo',
			'import_file_url'            => $demo_content_installer . '/default/main.xml',
			'import_customizer_file_url' => $demo_content_installer . '/default/customizer.dat',
			'import_widget_file_url'     => $demo_content_installer . '/default/widgets.wie',
			'import_preview_image_url'   => $demo_content_installer . '/default/screenshot.png',
			'preview_url'                => CUINARE_LIVE_URL
		],
		[
			'import_file_name'           => 'Cuinare Multivendor Demo',
			'import_file_url'            => $demo_content_installer . '/multivendor/main.xml',
			'import_customizer_file_url' => $demo_content_installer . '/multivendor/customizer.dat',
			'import_widget_file_url'     => $demo_content_installer . '/multivendor/widgets.wie',
			'import_preview_image_url'   => $demo_content_installer . '/multivendor/screenshot.png',
			'preview_url'                => CUINARE_LIVE_URL
		],
	];
}

add_action( 'pt-ocdi/import_files', 'cuinare_import_files' );

function cuinare_after_import( $selected_import ) {
	// Set homepage in imported demo
	$page_setup_array = [
		"Cuinare Demo" => [
			"slug" => "Home",
		]
	];

	// RevSlider import when importing the demo content.
	if ( class_exists( 'RevSliderSlider' ) ) {

		// Now you can use it!
		$slider_url_one = CUINARE_REMOTE_CONTENT . '/default/slider/home-1.zip';


		$sliders_array = array(
			download_url( $slider_url_one ),
		);

		$slider = new RevSlider();
		if(is_array( $sliders_array )) {
			foreach( $sliders_array as $filepath ) {
				$slider->importSliderFromPost( true, true, $filepath );
			}
		}
	}


	if ( is_array( $page_setup_array ) ) {
		foreach ( $page_setup_array as $i => $values ) {
			if ( $i === $selected_import['import_file_name'] ) {
				foreach ( $values as $key => $value ) {
					//Set Front page
					$page = get_page_by_title( $values['slug'] );
					if ( isset( $page->ID ) ) {
						update_option( 'page_on_front', $page->ID );
						update_option( 'show_on_front', 'page' );
					}
				}
			}
		}
	}

	// Set menu after demo import
	$primary_menu    = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
	$footer_menu     = get_term_by( 'name', 'Footer Menu', 'nav_menu' );
	$sub_header_menu = get_term_by( 'name', 'Sub Header Menu', 'nav_menu' );
	set_theme_mod( 'nav_menu_locations', [
			'primary'    => $primary_menu->term_id,
			'footermenu' => $footer_menu->term_id,
			'submenu'    => $sub_header_menu->term_id,
		]
	);
}

add_action( 'pt-ocdi/after_import', 'cuinare_after_import' );
