<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * enqueue all theme scripts and styles
 */
// stylesheets
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	// 3rd party css
	if(!class_exists('CSF')){
		wp_enqueue_style( 'cuinare-fonts', 'https://fonts.googleapis.com/css2?family=DM+Serif+Display&family=Jost:wght@300;400;500;600;700;800;900&display=swap', [], null );
	}
	
	wp_enqueue_style( 'bootstrap-min',  CUINARE_CSS . '/bootstrap.min.css', null,  CUINARE_VERSION );
	wp_enqueue_style( 'icon-font',  CUINARE_CSS . '/icon-font.css', null,  CUINARE_VERSION );
	wp_enqueue_style( 'overlay-scrollbars-min',  CUINARE_CSS . '/OverlayScrollbars.min.css', null,  CUINARE_VERSION );

	if( is_rtl() ){
		wp_enqueue_style( 'bootstrap-rtl',  CUINARE_CSS . '/bootstrap.min-rtl.css', null,  CUINARE_VERSION );
	}

	wp_enqueue_style( 'cuinare-woocommerce', CUINARE_CSS . '/woocommerce.css', null, CUINARE_VERSION );

   // theme css
	wp_enqueue_style( 'cuinare-blog',  CUINARE_CSS . '/blog.css', null,  CUINARE_VERSION );
	wp_enqueue_style( 'cuinare-master',  CUINARE_CSS . '/master.css', null,  CUINARE_VERSION );
	wp_enqueue_style( 'cuinare-dokan',  CUINARE_CSS . '/dokan.css', null,  CUINARE_VERSION );
}

// javascripts
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	
	wp_enqueue_script( 'popper',  CUINARE_JS . '/Popper.js', array( 'jquery' ),  CUINARE_VERSION, true );
	wp_enqueue_script( 'bootstrap-min',  CUINARE_JS . '/bootstrap.min.js', array( 'jquery' ),  CUINARE_VERSION, true );
	if ( is_rtl() ) {
		wp_enqueue_script( 'bootstrap-rtl',  CUINARE_JS . '/bootstrap.min-rtl.js', array( 'jquery' ),  CUINARE_VERSION, true );
	}
   // 3rd party scripts

    // theme scripts
	wp_enqueue_script( 'jquery-overlay-scrollbars-min',  CUINARE_JS . '/jquery.overlayScrollbars.min.js', array( 'jquery' ),  CUINARE_VERSION, true );
		
	// theme scripts
	wp_enqueue_script( 'cuinare-script',  CUINARE_JS . '/script.js', array( 'jquery' ),  CUINARE_VERSION, true );
	wp_localize_script( 'cuinare-script', 'cuinare_ajax', array(
		'ajax_url' => esc_url(admin_url( 'admin-ajax.php' )),
		 
		) );
	// Load WordPress Comment js
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}