<?php
namespace Elementor;


if (! defined( 'ABSPATH' ) ) exit;

class Widget_Woo_Mini_Cart extends Widget_Base {

	public $base;

    public function get_name()
    {
        return 'woo-mini-cart';
    }

    public function get_title()
    {
        return esc_html__('Woo mini cart', 'cuinare');
    }

    public function get_icon()
    {
        return 'eicon-cart-solid';
    }


    protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'cuinare' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ekit_woo_mini_cart_icons',
			[
				'label' => esc_html__( 'Icon', 'cuinare' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon icon-cart2',
                    'library' => 'fa fa-solid',
                ],
			]
        );
        
        $this->add_control(
            'ekit_woo_mini_cart_visibility',
            [
                'label' => esc_html__( 'Cart Visibility', 'cuinare' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'click',
				'options' => [
					'click'     => esc_html__( 'Click', 'cuinare' ),
					'hover'     => esc_html__( 'Hover', 'cuinare' ),
				],

            ]
        );

        $this->add_responsive_control(
            'ekit_woo_mini_cart_alignment',
            [
                'label' =>esc_html__( 'Alignment', 'cuinare' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' =>esc_html__( 'Left', 'cuinare' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' =>esc_html__( 'Center', 'cuinare' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' =>esc_html__( 'Right', 'cuinare' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekit-mini-cart' => 'text-align: {{VALUE}};'
                ],
                'default' => 'left',
            ]
        );

        $this->end_controls_section();

        // menu btn
        $this->start_controls_section(
			'ekit_mini_cart_menu_button_section',
			[
				'label' => esc_html__( 'Cart Button', 'cuinare' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
            'ekit_mini_cart_menu_button_padding',
            [
                'label' => esc_html__( 'Padding', 'cuinare' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .wpc_cart_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'ekit_mini_cart_menu_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'cuinare' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpc_cart_icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'ekit_mini_cart_menu_button_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'cuinare' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .wpc_cart_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
        );
        
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'ekit_mini_cart_menu_button_shadow',
				'selector' => '{{WRAPPER}} .wpc_cart_icon',
			]
		);

        $this->start_controls_tabs('ekit_mini_cart_menu_button_color_tabs');
            $this->start_controls_tab(
                'ekit_mini_cart_menu_button_color_normal_tab',
                [
                    'label' => esc_html__('Normal', 'cuinare')
                ]
            );

            $this->add_control(
                'ekit_mini_cart_menu_button_normal_color',
                [
                    'label'     => esc_html__( 'Color', 'cuinare' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpc_cart_icon' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                array(
                    'name'     => 'ekit_mini_cart_menu_button_normal_bg_color',
                    'selector' => '{{WRAPPER}} .wpc_cart_icon, {{WRAPPER}} .wpc_cart_icon .basket-item-count',
                )
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'      => 'ekit_mini_cart_menu_button_border',
                    'label'     => esc_html__( 'Border', 'cuinare' ),
                    'selector'  => '{{WRAPPER}} .wpc_cart_icon',
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'ekit_mini_cart_menu_button_color_hover_tab',
                [
                    'label' => esc_html__('Hover', 'cuinare')
                ]
            );

            $this->add_control(
                'ekit_mini_cart_menu_button_hover_color',
                [
                    'label'     => esc_html__( 'Color', 'cuinare' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpc_cart_icon:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'ekit_mini_cart_menu_button_hover_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'cuinare' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpc_cart_icon:hover, {{WRAPPER}} .wpc_cart_icon:hover .basket-item-count' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'      => 'ekit_mini_cart_menu_hover_button_border',
                    'label'     => esc_html__( 'Border', 'cuinare' ),
                    'selector'  => '{{WRAPPER}} .wpc_cart_icon:hover',
                ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
        // end menu btn
    }

    protected function render() {
        if(class_exists( 'WooCommerce' )) {
            echo '<div class="ekit-wid-cons" >';
                $this->render_raw();
            echo '</div>';
        }
    }
    
    protected function render_raw(){

        $settings = $this->get_settings();
        ?>
        <div class="minicart-widget-style">
            <div class="wpc-minicart-wrapper style2 wpc-cart_main_block">
                <a href="#" class="wpc_cart_icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['ekit_woo_mini_cart_icons'], [ 'aria-hidden' => 'true' ] ); ?>
                    <sup class="basket-item-count" style="display: inline-block;">
                        <span class="cart-items-count count wpc-mini-cart-count"></span>
                    </sup>
                </a>
                <div class="wpc_cart_block">
                    <div class="wpc-minicart-header">
                        <div class="cart-counts">
                            <?php echo esc_html__('Cart', 'wpcafe'); ?>
                            <span class="cart-count">
                                (<span class="cart-items-count count wpc-mini-cart-count"></span><?php echo esc_html__(' items', 'wpcafe'); ?>)
                            </span>
                        </div>
                        <button type="button" class="minicart-close wpc-btn-border wpc-btn">
                            <svg width="12" height="12" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path 
                                fill-rule="evenodd" 
                                clip-rule="evenodd" 
                                d="M2.76992 0.7523C2.28177 0.264145 1.49031 0.264145 1.00216 0.7523C0.514001 1.24046 0.514001 2.03191 1.00216 2.52007L6.48223 8.00014L1.00216 13.4802C0.514002 13.9684 0.514001 14.7598 1.00216 15.248C1.49031 15.7361 2.28177 15.7361 2.76992 15.248L8.25 9.76791L13.7301 15.248C14.2182 15.7361 15.0097 15.7361 15.4978 15.248C15.986 14.7598 15.986 13.9684 15.4978 13.4802L10.0178 8.00014L15.4978 2.52007C15.986 2.03191 15.986 1.24046 15.4978 0.7523C15.0097 0.264145 14.2182 0.264145 13.7301 0.7523L8.25 6.23238L2.76992 0.7523Z" 
                                fill="white"/>
                            </svg>
                        </button>
                    </div>
                    <div class="wpc-menu-mini-cart wpc_background_color">
                        <div class="widget_shopping_cart_content">
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
}