<?php
namespace Elementor;

if (!defined('ABSPATH')) exit;

use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

class Multivendor_Product_Slider extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'multivendor-product-slider';
    }

    public function get_title()
    {
        return esc_html__('Multivendor Product Slider', 'cuinare');
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['cuinare-elements'];
    }

    protected function register_controls()
    
    {

        $this->start_controls_section(
            'general_section_tab',
            [
                'label' => esc_html__('General', 'cuinare'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'product_by',
			[
				'label'     => esc_html__('Show product by', 'cuinare'),
				'type'      => Controls_Manager::SELECT2,
				'options'   => [
					'category' => esc_html__('Category', 'cuinare'),
					'product'  => esc_html__('Product', 'cuinare')
				],
				'default'   => 'category',
				'seperator' => 'before'
			]
		);

        $this->add_control(
			'term_list',
			[
				'label'       => esc_html__('Select Categories', 'cuinare'),
				'type'        => ElementsKit_Controls_Manager::AJAXSELECT2,
				'options'     => 'ajaxselect2/product_cat',
				'multiple'    => true,
				'label_block' => true,
				'condition'   => [
					'product_by' => 'category'
				]
			]
		);

        $this->add_control(
            'product_list',
            [
                'label' => esc_html__('Select Products', 'cuinare'),
                'type' => ElementsKit_Controls_Manager::AJAXSELECT2,
                'options'   => 'ajaxselect2/product_list',
                'multiple' => true,
                'label_block' => true,
                'condition'    => [
                    'product_by'    => 'product'
                ]
            ]
        );

        $this->add_control(
            'products_per_page',
            [
                'label' => esc_html__('Products Count', 'cuinare'),
                'type' => Controls_Manager::NUMBER,
                'default'   => (isset($default['page']) ? esc_attr($default['page']) : 6),
            ]
        );

        $this->add_control(
            'product_order',
            [
                'label' => esc_html__('Order', 'cuinare'),
                'type' => Controls_Manager::SELECT,
                'default'   => (isset($default['order']) ? esc_attr($default['order']) : 'DESC'),
                'options'   => [
                    'ASC'       => esc_html__('ASC', 'cuinare'),
                    'DESC'      => esc_html__('DESC', 'cuinare'),
                ],
            ]
        );

        $this->add_control(
            'product_orderby',
            [
                'label' => esc_html__('Order By', 'cuinare'),
                'type' => Controls_Manager::SELECT,
                'default'   => (isset($default['orderby']) ? esc_attr($default['orderby']) : 'date'),
                'options'   => [
                    'ID'       => esc_html__('ID', 'cuinare'),
                    'title'       => esc_html__('Title', 'cuinare'),
                    'name'      => esc_html__('Name', 'cuinare'),
                    'date'      => esc_html__('Date', 'cuinare'),
                    'comment_count'      => esc_html__('Popular', 'cuinare'),
                ],
            ]
        );

        $this->add_control(
			'add_to_cart_button_text',
			[
				'label' => esc_html__( 'Cart Button Text', 'cuinare' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add to cart text', 'cuinare' ),
			]
		);

        $this-> end_controls_section();
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Product Slider Settings', 'cuinare'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slider_items',
            [
                'label'         => esc_html__('Slide Items', 'cuinare'),
                'type'          => Controls_Manager::NUMBER,
                'default'       => 4
            ]
        );

        $this->add_control(
            'ts_slider_loop',
            [
                'label' => esc_html__( 'Loop', 'cuinare' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'cuinare' ),
                'label_off' => esc_html__( 'No', 'cuinare' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'ts_slider_autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'cuinare' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'cuinare' ),
                'label_off' => esc_html__( 'No', 'cuinare' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        
        $this->add_control(
            'show_navigation',
            [
                'label'       => esc_html__('Show Navigation', 'cuinare'),
                'type'        => Controls_Manager::SWITCHER,
                'label_on'    => esc_html__('Yes', 'cuinare'),
                'label_off'   => esc_html__('No', 'cuinare'),
                'default'     => 'yes'
            ]
        );

        $this->add_control(
			'left_arrow_icon',
			[
				'label' => esc_html__( 'Left Arrow Icon', 'cuinare' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-l-arrow',
					'library' => 'solid',
				],
                'condition' => ['show_navigation' => 'yes']
			]
		);

        $this->add_control(
			'right_arrow_icon',
			[
				'label' => esc_html__( 'Right Arrow Icon', 'cuinare' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-right-arrow',
					'library' => 'solid',
				],
                'condition' => ['show_navigation' => 'yes']
			]
		);

        
        $this->add_control(
            'slider_space_between',
            [
                'label'         => esc_html__('Slider Item Space', 'cuinare'),
                'description'   => esc_html__('Space between slides', 'cuinare'),
                'type'          => Controls_Manager::NUMBER,
                'return_value'  => 'yes',
                'default'       => 30
            ]
        );
        $this->end_controls_section();

        // Product slider style controller
        $this->start_controls_section(
            'cuinare_style_block_section',
            [
                'label' => esc_html__('Product Slider Content Style', 'cuinare'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_settings',
            [
                'label' => __('Content Style', 'cuinare'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
          'title_style_normal_tab',
          [
            'label' => __( 'Normal', 'cuinare' ),
            'seperator' => 'after'
          ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-single-store .single-product-item .product-loop-desc .product-title a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Description Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-single-store .single-product-item .product-loop-desc p.product-short-description' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'product_price_color',
            [
                'label' => esc_html__('Price Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-single-store .single-product-item .product-loop-desc .product-footer-wrapper .price-multiline, 
                    {{WRAPPER}} .dokan-single-store .single-product-item .product-loop-desc .product-footer-wrapper .price-multiline del' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'cart_btn_color',
            [
                'label' => esc_html__('Cart Text Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dokan-single-store .single-product-item .product-loop-desc .product-footer-wrapper .product-footer-action-buttons .add-to-cart-hover-box a' => 'color: {{VALUE}};'
                ],
            ]
        );
        
        $this->add_control(
            'cart_bg_color',
            [
                'label' => esc_html__('Cart Background', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc .product-footer-wrapper .product-footer-action-buttons .button' => 'background-color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'cart_btn_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .product-loop-desc .product-footer-wrapper .product-footer-action-buttons .button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
          'title_style_hover_tab',
          [
            'label' => __( 'Hover', 'cuinare' ),
          ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('Title Hover Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc:hover .product-title a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'desc_hover_color',
            [
                'label' => esc_html__('Description Hover Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc:hover .product-short-description' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'product_price_hover_color',
            [
                'label' => esc_html__('Price Hover Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc:hover .product-footer-wrapper .price-multiline, 
                    {{WRAPPER}} .product-loop-desc:hover .product-footer-wrapper .price-multiline del' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'cart_btn_color_hover',
            [
                'label' => esc_html__('Cart Text Color Hover', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc:hover .product-footer-wrapper .product-footer-action-buttons .button' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'cart_bg_hover_color',
            [
                'label' => esc_html__('Cart Background Hover', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-loop-desc:hover .product-footer-wrapper .product-footer-action-buttons .button' => 'background-color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'cart_btn_hover_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .product-loop-desc:hover .product-footer-wrapper .product-footer-action-buttons .button',
            ]
        );
        
        $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->add_control(
			'divider',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'title_typography_settings',
            [
                'label' => __('Typography', 'cuinare'),
                'type' => Controls_Manager::HEADING,
            ]
        );
        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .product-loop-desc .product-title a',
			]
       );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => esc_html__( 'Description', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .product-short-description',
			]
       );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => esc_html__( 'Price', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .product-loop-desc .product-footer-wrapper .price-multiline',
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'regular_price_typography',
				'label' => esc_html__( 'Regular Price', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .product-loop-desc .product-footer-wrapper .price-multiline del',
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => esc_html__( 'Cart Button', 'cuinare' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .product-loop-desc .product-footer-wrapper .product-footer-action-buttons .button',
			]
        );

        $this->add_control(
			'divider2',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'cuinare'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
                'default'   => [
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-loop-desc .product-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'cart_btn_padding',
			[
				'label' => esc_html__('Button Padding', 'cuinare'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
                'default'   => [
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-loop-desc .product-footer-wrapper .product-footer-action-buttons .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();


        // Slider Nav controls start
        $this->start_controls_section(
			'slider_section_style',
			[
				'label' => esc_html__( 'Slider Nav Style', 'cuinare' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_navigation' => 'yes']
			]
		);
        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'width', 'cuinare' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' , '%' ],
				'range' => [
					'%' => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
			
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'width: {{SIZE}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
			'icon_height',
			[
				'label' => esc_html__( 'Height', 'cuinare' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' , '%' ],
				'range' => [
					'%' => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
			
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->start_controls_tabs(
            'navigation_style_tabs'
        );
        
        $this->start_controls_tab(
          'navigation_style_normal_tab',
          [
            'label' => __( 'Normal', 'cuinare' ),
          ]
        );
        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Icon Background Color', 'cuinare' ),
                'default' => '#E4E8F8',
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_nav_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
          'navigation_style_hover_tab',
          [
            'label' => __( 'Hover', 'cuinare' ),
          ]
        );

        $this->add_control(
			'icon_color_hover',
			[
				'label' => esc_html__( 'Icon Hover Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'icon_bg_color_hover',
			[
				'label' => esc_html__( 'Icon Hover Background Color', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
                'default' => '#EE4D4D',
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_hover_nav_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => esc_html__( 'Typography', 'cuinare' ),
				'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
			]
		);

        $this->add_responsive_control(
			'nav_border_radius',
			[
				'label' => esc_html__( 'Nav Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_prev_position',
			[
				'label'       => esc_html__('Previous Button Position (x-axis)', 'cuinare'),
				'description' => esc_html__('(-) Negative values are allowed', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -10,
						'max' => 100,
					],
					'px' => [
						'min' => -500,
						'max' => 1100,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_prev_position_y',
			[
				'label'       => esc_html__('Previous Button Position (y-axis)', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -100,
						'max' => 300,
					],
					'px' => [
						'min' => -100,
						'max' => 300,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-prev' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_next_position',
			[
				'label'       => esc_html__('Next Button Position (x-axis)', 'cuinare'),
				'description' => esc_html__('(-) Negative values are allowed', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => -300,
						'max' => 300,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_next_position_y',
			[
				'label'       => esc_html__('Next Button Position (y-axis)', 'cuinare'),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => ['px', '%'],
				'range'       => [
					'%'  => [
						'min' => -100,
						'max' => 200,
					],
					'px' => [
						'min' => -100,
						'max' => 200,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .swiper-button-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();


        // Slider Wrapper controls start
        $this->start_controls_section(
			'slider_wrapper_section_style',
			[
				'label' => esc_html__( 'Slider Wrapper Style', 'cuinare' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs(
            'slider_wrapper_style_tabs'
        );

        $this->start_controls_tab(
            'slider_wrapper_style_normal_tab',
            [
              'label' => __( 'Normal', 'cuinare' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'product_content_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .single-product-item .product-loop-desc',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'product_wrapper_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'cuinare' ),
				'selector' => '{{WRAPPER}} .single-product-item',
			]
		);

        $this->add_control(
			'product_content_wrapper',
			[
				'label' => esc_html__( 'Product Content Background', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-product-item .product-loop-desc' => 'background-color: {{VALUE}}',
				],
			]
		);


        $this-> end_controls_tab();

        $this->start_controls_tab(
            'slider_wrapper_style_hover_tab',
            [
              'label' => __( 'Hover', 'cuinare' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'product_content_hover_border',
                'label' => __( 'Border', 'cuinare' ),
                'selector' => '{{WRAPPER}} .single-product-item .product-loop-desc:hover',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'product_wrapper_box_shadow_hover',
				'label' => esc_html__( 'Box Shadow', 'cuinare' ),
				'selector' => '{{WRAPPER}} .single-product-item:hover',
			]
		);

        $this->add_control(
			'product_content_wrapper_hover',
			[
				'label' => esc_html__( 'Product Content Background Hover', 'cuinare' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-product-item .product-loop-desc:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this-> end_controls_tab();

        $this-> end_controls_tabs();

        $this->add_control(
			'divider3',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_responsive_control(
			'product_wrapper_padding',
			[
				'label' => esc_html__('Product Content Padding', 'cuinare'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
                'default'   => [
					'top' => '',
					'right' => '',
					'bottom' => '',
					'left' => '',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .single-product-item .product-loop-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'product_wrapper_border_radius',
			[
				'label' => esc_html__( 'Product Content Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-product-item .product-loop-desc' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'divider4',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_responsive_control(
			'product_wrapper_margin',
			[
				'label' => esc_html__('Product Item Margin', 'cuinare'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
                'default'   => [
					'top' => '',
					'right' => '',
					'bottom' => '',
					'left' => '',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .single-product-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'product_item_border_radius',
			[
				'label' => esc_html__( 'Product Item Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-product-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this-> end_controls_section();

        

        
    }

    protected function render( ) {

        $settings          =    $this->get_settings();

        $args = array(
            'post_type'         => 'product',
            'posts_per_page'    => isset($settings['products_per_page']) ? $settings['products_per_page'] : 6,
            'order'             => isset($settings['product_order']) ? $settings['product_order'] : 'DESC',
            'orderby'           => isset($settings['product_orderby']) ? $settings['product_orderby'] : 'date',
            'hide_empty'        => 0
        );

        if($settings['product_by'] == 'category'){
            $args['tax_query'] = [
                [
                    'taxonomy'   => 'product_cat',
                    'field'      => 'term_id',
                    'terms'      => !empty($settings['term_list']) ? $settings['term_list'] : [],
                ],
            ];
        }

        if($settings['product_by'] == 'product'){
            $args['post__in'] = !empty($settings['product_list']) ? $settings['product_list'] : [];
        }

        $all_products = get_posts($args);

        $show_navigation = $settings["show_navigation"] == "yes"?true: false;
        $autoplay_slider = $settings['ts_slider_autoplay'];
        $slider_items    = $settings['slider_items'];
        $slider_item_gap = $settings['slider_space_between'];
        $slider_loop     = $settings['ts_slider_loop'];
        $button_text     = $settings['add_to_cart_button_text'];

        $slide_controls    = [
            'slider_loop' => $slider_loop,
            'autoplay_slide'=> $autoplay_slider, 
            'show_nav'=>$show_navigation, 
            'slider_items' => $slider_items,
            'slider_item_gap' => $slider_item_gap,
            'widget_id' => $this->get_id()
        ];
        $slide_controls = \json_encode($slide_controls); 
      ?>
        <div class="multivendor-product-slider dokan-single-store" data-controls="<?php echo esc_attr($slide_controls); ?>">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    <?php foreach ( $all_products as $post): ?>
                    <div class="swiper-slide">
                        <div class="product-slider-wrapper">
                            <?php cuinare_multivendor_product_loop($post -> ID, $title_length = 10, $excerpt_length = 10,  $button_text); ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <!-- Next Previous Arrow -->
            <?php if($show_navigation =='yes'){ ?>
                <!-- next / prev arrows -->
                <div class="swiper-button-next swiper-next-<?php echo esc_attr($this->get_id()); ?>"> 
                    <?php \Elementor\Icons_Manager::render_icon( $settings['right_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <div class="swiper-button-prev swiper-prev-<?php echo esc_attr($this->get_id()); ?>">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['left_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
                <?php } ?>
        </div>
    <?php
    }
    protected function content_template() { }
}
